/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CMutexImpDrv98.h,v 1.2 1999/09/17 04:20:50 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CMutexImpDrv98_h	// [
#define Included_CMutexImpDrv98_h

#include "pgpClassesConfig.h"
#include "CMutexImp.h"

_PGP_BEGIN

// Class CMutexImpDrv98

class CMutexImpDrv98 : public CMutexImp
{
	friend class CPFLImpFactoryDrv98;

private:
	CMutexImpDrv98();
	~CMutexImpDrv98();

	PGPUInt32	Enter(PGPInt32 msTimeout);
	void		Leave();

private:
	MUTEXHANDLE	mMutex;
};


// Class CMutexImpDrv98 member functions

inline 
CMutexImpDrv98::CMutexImpDrv98()
{
	if (IsNull(mMutex = _CreateMutex(0, NULL)))
		Status().pgpErr = kPGPError_SyncObjOpFailed;
}

inline 
CMutexImpDrv98::~CMutexImpDrv98()
{
	if (IsntNull(mMutex))
	{
		_DestroyMutex(mMutex);
		mMutex = NULL;
	}
}

inline 
PGPUInt32 
CMutexImpDrv98::Enter(PGPInt32 msTimeout)
{
	pgpAssert(msTimeout == CMutex::InfiniteTimeout);
	_EnterMutex(mMutex, BLOCK_SVC_INTS | BLOCK_THREAD_IDLE);

	return 0;
}

inline 
void 
CMutexImpDrv98::Leave()
{
	_LeaveMutex(mMutex);
}

_PGP_END

#endif	// ] Included_CMutexImpDrv98_h
